/*************************************************************************
 *
 * Hitchhiker's Guide to the IBM PE 
 * Demonstration of use of pmarray
 * Chapter 3 - Don't Panic
 *
 * To compile:
 * mpcc -g -o use_pmarray use_pmarray.c
 *
 *************************************************************************/

#include<stdlib.h>
#include<stdio.h>
#include <mpi.h>
#include<time.h>

int main(int argc, char **argv)
{
  int i, j;
  int inner_loops = 16, outer_loops;
  int me;
  char buffer[256];
  time_t start, now;

  MPI_Init(&argc,&argv);
  MPI_Comm_rank(MPI_COMM_WORLD,&me);

  if(argc>1) outer_loops = atoi(argv[1]);
  if(outer_loops<1) outer_loops = 16;
  
  for(i=0;i<outer_loops;i++) 
    {
      /* Create message that will be shown in pmarray text area */
      sprintf(buffer,"Task %d performing loop %d of %d",me,i,outer_loops);
      printf("%s\n",buffer);
      for(j=0;j<inner_loops;j++)
	{
	  /* pmarray light shows which outer loop we are in  */
	  /* color of light shows which inner loop we are in */
	  /* text in buffer is created in outer loop         */
	  mpc_marker(i,5*j,buffer);
	}

      /* Pause for a number of seconds determined by which */
      /* task this is.  sleep(me) cannot be used because   */
      /* underlying communication mechanism uses a regular */
      /* timer interrupt that interrupts the sleep call    */
      /* Instead, we'll look at the time we start waiting  */
      /* and then loop until the difference between the    */
      /* time we started and the current time is equal to  */
      /* the task id                                       */
      time(&start);
      time(&now);
      while(difftime(now,start)<(double)me) 
	{
	  time(&now);
	}
    }
  MPI_Finalize(); 
  return 0;
}
